<?php
/* --------------------------------------------------------------
   TrackingCode.php 2020-03-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Interfaces;

use JsonSerializable;

/**
 * Interface TrackingCode
 *
 * @package Gambio\Admin\TrackingCode\Interfaces
 */
interface TrackingCode extends JsonSerializable
{
    /**
     * @return int|null
     */
    public function id(): ?int;
    
    
    /**
     * @return int
     */
    public function orderId(): int;
    
    
    /**
     * @return string
     */
    public function code(): string;
    
    
    /**
     * @return int
     */
    public function languageId(): int;
    
    
    /**
     * @return int
     */
    public function parcelServiceId(): int;
    
    
    /**
     * @return string
     */
    public function parcelServiceName(): string;
    
    
    /**
     * @return string
     */
    public function url(): string;
    
    
    /**
     * @return string
     */
    public function comment(): string;
    
    
    /**
     * @param string $format
     *
     * @return string
     */
    public function createdOn(string $format = 'Y-m-d H:i:s'): string;
}